<?php

class AdminOrdersController extends AdminOrdersControllerCore
{
    public function __construct()
    {

        parent::__construct(); // On appelle le constructeur du parent (le controleur natif)

        // On recupere l'id_carrier qui va ensuite etre utile pour la methode printCarrierIcon()
        $this->_select .= ', oc.`id_carrier`,';

        // On ajoute une jointure pour atteindre l'id_carrier
        $this->_join .= 'LEFT JOIN `'._DB_PREFIX_.'order_carrier` oc ON (a.`id_order` = oc.id_order)';

        // On definit la nouvelle colonne avec icone du transporteur
        $carrier_column = array(
            'title' => $this->l('Carrier'),
            'align' => 'text-center',
            'callback' => 'printCarrierIcon',
            'orderby' => true,
            'search' => false,
        );

        // On l'integre a la liste (ici en 3eme position)
        $part1 = array_slice($this->fields_list, 0, 2);
        $part2 = array_slice($this->fields_list, 2);
        $part1['id_carrier'] = $carrier_column;
        $this->fields_list = array_merge($part1, $part2);

    }

    // Recuperation de l'image du transporteur
    public function printCarrierIcon($id_order, $tr)
    {
        if (file_exists(_PS_TMP_IMG_DIR_ . 'carrier_mini_' . $tr['id_carrier'] . '_1.jpg')) {
            return '<img src="../img/tmp/carrier_mini_' . $tr['id_carrier'] . '_1.jpg'.'" class="imgm img-thumbnail" />';
        }
        return null;
    }

}